
import React from 'react';
import autoBind from 'react-autobind';

import ControlRegister from '../Registers/ControlRegister'
import EventRegister from '../Registers/EventRegister'
import { ControlLog as Log } from '../Tools/LogTools'


export default class BaseControl extends React.Component {

    static controlRegister = ControlRegister.Get();
    static eventRegister = EventRegister.Get();    

    //  
    static GlobalState = {};
    

    constructor(props, name) {
        super(props);
        this.Name = name;
        autoBind(this);

        this.GlobalState = BaseControl.GlobalState;
        this.EventRegister = BaseControl.eventRegister;

        this.Log = (Msg) => { Log(this, Msg); };
        
        BaseControl.controlRegister.RegisterControl(this);

        this.Log("start");
    }

    componentWillUnmount() {
        //console.log(this.name + " stop " + this.ID);

        BaseControl.controlRegister.UnregisterControl(this);
        if (this.IsEventListener === true)
            BaseControl.eventRegister.UnregistListener(this);
    }
}
