﻿
import React from 'react';
import { Link } from 'react-router-dom';

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'


export default class MenuControl extends BaseControl {

    constructor(props) {
        super(props, "MenuControl");

        //this.state = { counter: 0 };
        this.authServices = new AuthServices();

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.forceUpdate();
    }

    render() {
        return (
            <div>

                <table>
                    <thead>
                        <tr>
                            <td>Menu:</td>
                            <td>
                                <Link to={`/`}>
                                    <button>FS</button>
                                </Link>
                            </td>

                            {this.authServices.IsAuth()
                                ?
                                <td>
                                    <Link to={`/Admin`}>
                                        <button>Admin</button>
                                    </Link>
                                </td>
                                : <td></td>
                            }
                        </tr>
                    </thead>                    
                </table>

            </div >
        );
    }
}

