﻿
import React from 'react';
import ReactDOM from 'react-dom';
import { BrowserRouter as Router, Route, Switch } from 'react-router-dom';

import BaseControl from './BaseControl.jsx'
import FileExplorerPage from './Pages/FileExplorerPage.jsx'
import AdministratorPage from './Pages/AdministratorPage.jsx'  


export default class RouteSystem extends BaseControl {

    constructor(props) {
        super(props, "RouteSystem");
    }

    render() {
        return (
            <Router>
                <Switch>
                    <Route ref="CurrentPage" exact path="/" component={FileExplorerPage} />
                    <Route ref="CurrentPage" exact path="/App" component={FileExplorerPage} />
                    <Route ref="CurrentPage" exact path="/index.html" component={FileExplorerPage} />
                    <Route ref="CurrentPage" path="/?ID=:ID" component={FileExplorerPage} />
                    <Route ref="CurrentPage" path="/Admin" component={AdministratorPage} />
                </Switch>
            </Router>
        );
    }
}

ReactDOM.render(
    <RouteSystem />,
    document.getElementById("App")
)

