﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.Text;
using System.Data.Entity;

using Model.Entities.Users;
using Model.ViewModel;
using Web.Models.Base;
using Web.Models;
using BLL.Services.Mapper;

namespace Web.Controllers.API.Admin
{

    public class UserController : Base.BaseApiController
    {
        readonly UserMapper UserMapper;

        public UserController()
        {
            UserMapper = new UserMapper(UOW);
        }

        //[HttpPost]
        //public JsonResult CreateUser(string Login, string Password)
        //{
        //    UOW.Repo_User.Create(new User()
        //    {
        //        Login = Login,
        //        Password = Password,
        //        IsActive = true,
        //        Groups = new List<Group>()
        //        {
        //            UOW.Repo_Group.GetDefaultGroup(EnumDefaultGroups.Пользователи)
        //        }
        //    });

        //    return Json(true, JsonRequestBehavior.AllowGet);
        //}


        [HttpPost]
        public JsonResult GetUserList()
        {
            UserListMode json;

            if (CurrentUser != null && CurrentUser.IsAdmin)
            {
                json = new UserListMode(true)
                {
                    Users = UserMapper.UserToEditUser_List(),
                    Groups = UserMapper.GroupToGroupInfo_ForUsers()
                };
            }
            else
            {
                json = new UserListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                };
            }

            return Json(json);
        }

        [HttpPost]
        public JsonResult SetUserList(List<EditUserModel> model)
        {
            if (!CurrentUser.IsAdmin)
                return Json(new BaseApiResult(false, "", ""));

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Users = UserMapper.EditUserToUser_List(model);

            foreach (var elem in Users)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_User.Create(elem.DBUser);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_User.Update(elem.DBUser);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_User.Delete(elem.DBUser);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return Json(new BaseApiResult(!HaveErr, res.ToString(), "SetUserList"));
        }


        public class UserListMode : BaseApiResult
        {
            public UserListMode(bool Successe) : base(Successe, "", "UserList") { }

            public List<EditUserModel> Users;
            public List<GroupInfo> Groups;
        }



        [HttpPost]
        public JsonResult GetGroupList()
        {
            GroupListMode json;

            if (CurrentUser != null && CurrentUser.IsAdmin)
            {
                var groups = UOW.Repo_Group.All_NoTrack_List;

                var model = UserMapper.GroupToGroupEditor();


                json = new GroupListMode(true)
                {
                    Groups = model,
                    RootDirs = UserMapper.RootDirs()
                };

            }
            else
            {
                json = new GroupListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                };
            }

            return Json(json);
        }
        //[HttpPost]
        //public JsonResult SetGroupList() { }

        public class GroupListMode : BaseApiResult
        {
            public GroupListMode(bool Successe) : base(Successe, "", "GroupList") { }

            public List<GroupInfo> Groups;
            public List<RootDirInfo> RootDirs;
        }

    }
}