﻿
import React from 'react';
import { Form, Button, Alert } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import AuthServices from '../../../Services/AuthServices'

import BaseControl from '../../BaseControl.jsx'



export default class UserControl extends BaseControl {

    constructor(props) {
        super(props, "UserControl");

        this.authServices = new AuthServices();
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            CurrentUser: this.GlobalState.User != undefined
                ? this.GlobalState.User
                : this.UserInfo(null)
        };

        if (this.authServices.IsAuth())
            this.authServices.GetUserInfoAsync().then(function (data) {

                if (data.Successe) {
                    this.GlobalState.User = this.UserInfo(data.User);
                }
                else {
                    this.GlobalState.User = this.UserInfo(null);                   

                    Notification.MesEr(data.ResMessage, "Auth");
                }

                this.setState ({
                    IsAuth: this.authServices.IsAuth(),
                    CurrentUser: this.GlobalState.User
                });
                this.EventRegister.EventAction("OnAuthChange");

            }.bind(this));
    }

    UserInfo(user) {
        if (user == null)
            return {
                Login: "",
                IsAdmin: false
            };

        return {
            Login: user.Login,
            IsAdmin: user.IsAdmin
        };
    }

    //Кнопка входа
    AuthClick() {
        let login = this.refs.Login.value;
        let password = this.refs.Password.value;

        this.authServices.AuthAsync(login, password)
            .then(function (data) {

                if (data.Successe) {
                    this.GlobalState.User = this.UserInfo(data.User);
                }
                else {
                    this.GlobalState.User = this.UserInfo(null);

                    Notification.MesEr(data.ResMessage, "Auth");
                }

                this.setState({
                    IsAuth: this.authServices.IsAuth(),
                    CurrentUser: this.GlobalState.User
                });
                this.EventRegister.EventAction("OnAuthChange");

            }.bind(this));
    }

    //Кнопка выхода
    LogoutClick() {
        this.authServices.Logout();
        this.GlobalState.User = this.UserInfo(null);

        this.setState({
            IsAuth: this.authServices.IsAuth(),
            CurrentUser: this.GlobalState.User
        });
        this.EventRegister.EventAction("OnAuthChange");
    }


    render() {
        let state = this.state;

        return (
            <div>
                {this.state.IsAuth
                    ?
                    <div>                       
                        <Alert variant="success">Вы авторизованы. Пользователь: {this.state.CurrentUser.Login}.</Alert>
			{this.state.CurrentUser.IsAdmin
                            ? <Alert variant="success">Вы администратор.</Alert>                        
                            : null
                        }
			<Button onClick={this.LogoutClick} variant="danger">Выход</Button>
                    </div>
                    :
                    <div>
                        <Alert variant="warning">Вы не авторизованы. <b>Вход:</b></Alert>
                        {/*{state.AuthResult != "" ? <p>{state.AuthResult}</p> : ""}*/}

                        {/*<Form.Label>Email address</Form.Label>*/}
                        <Form.Control ref="Login" type="text" placeholder="Enter login" />
                        <Form.Text className="text-muted">
                            We'll never share your login with anyone else.
                        </Form.Text>
                        <br />
                        {/*<Form.Label>Password</Form.Label>*/}
                        <Form.Control ref="Password" type="password" placeholder="Password" />
                        <br />
                        <Button onClick={this.AuthClick} variant="success">Авторизация</Button>
                    </div>
                }
            </div>
        );
    }
}
