
import React from 'react';
import { Form } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import UploadServices from '../../../Services/UploadServices'

import BaseControl from '../../BaseControl.jsx'


export default class SearchControl extends BaseControl {

    constructor(props) {
        super(props, "SearchControl");

        this.EventRegister
            .RegisterListener(this.GetDirectory().ChangeEvent, this);
    }

    Event_OnItemsChange_Main() {
        this.refs.SearchInput.value = "";
    }
    Event_OnItemsChange_Move() {
        this.refs.SearchInput.value = "";
    }

    GetDirectory() {
        return this.GlobalState[this.props.CurrentDirectoryName];
    }

    OnSearchChange() {
        this.GetDirectory().ExplorerControl
            .setState({
                SearchString: this.refs.SearchInput.value
            });
    }


    render() {
        return (
            <div>
                <Form.Control ref="SearchInput" type="text" onChange={this.OnSearchChange} placeholder="Search" style={{ marginBottom: 10 }} />
            </div>
        );
    }
}