﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.IO;
using System.Threading.Tasks;
using System.Data.Entity;
using System.Data;

using Web.Models.Base;

using Model.Entities.Files;
using Model.Entities.Files.FS_Entities;
using Model.UnitsOfWork;
using Model.ViewModel.Files;

using BLL.Services;
using BLL.Services.Mapper;
using BLL.Services.FS;

namespace Web.Controllers.API
{
    class ViewModelItems : BaseApiResult
    {
        public int ParentID { set; get; }
        public List<PathItem> Path;
        public string ParentName { set; get; }
        public int CurrentID { set; get; }        

        public List<ExplorerItem> items { set; get; }


        public ViewModelItems(Base.BaseController controller, bool Successe, string ResMessage)
            : base(controller, Successe, ResMessage) { }

    }    

    public class DeleteResult : BaseApiResult
    {
        public DeleteResult(Base.BaseController controller, bool Successe, string ResMessage)
             : base(controller, Successe, ResMessage) { }
    }


    public class ExplorerController : Base.BaseApiController
    {
        readonly ExplorerMapper ExplorerMapper;

        public ExplorerController()
        {
            ExplorerMapper = new ExplorerMapper(UOW, permissionServices, CurrentUserFunc);
        }


        [HttpGet]
        public JsonResult GetDirectoryItems(int ID)
        {
            if (ID == -1)
            {
                //#Data #Permission
                //Выбрать корренные папки, к которым имеет доступ текущий пользователь
                //var data = UOW.Repo_SRootDirectory.All_NoTrack_List.
                //    Where(e => permissionServices.CanOpen(CurrentUser, e)).ToList();

                return new ViewModelItems(this, true, "")
                {
                    ParentID = -1,
                    ParentName = "Корень",
                    CurrentID = ID,

                    Path = ExplorerMapper.GetPath(ID),
                    items = ExplorerMapper.GetDirectoryItems(ID)
                }.ToJson;
            }
            else
            {
                //#Data
                var data = UOW.Repo_SDirectory.All_NoTrack.
                    Where(e => e.ID == ID).
                    First();

                //#Permission
                if (!permissionServices.CanOpen(CurrentUser, data))
                {
                    return new ViewModelItems(this, false, "CanOpen permission error")
                    {
                        PermissionError = true,
                        Path = PathItem.GetPermissionError(data.ID),
                        items = new List<ExplorerItem>()
                    }.ToJson;
                }                
            
                return new ViewModelItems(this, true, "")
                {
                    ParentID = data.IsRoot ? -1 : data.Parent_ID.Value,
                    ParentName = data.IsRoot ? "Корень" : data.Parent.Name,

                    Path = ExplorerMapper.GetPath(ID),
                    items = ExplorerMapper.GetDirectoryItems(ID)
                }.ToJson;
            }
        }


        [HttpGet]
        public FileResult GetFile(int ID)
        {
            //#Data
            var file = UOW.Repo_SFile.All_NoTrack.
                FirstOrDefault(e => e.ID == ID);

            //#Permission
            if (!permissionServices.CanDownload(CurrentUser, file.Root))
            {
                MemoryStream res = new MemoryStream();

                return File(res, "application/octet-stream", "CanDownload permission error");
            }


            return File(file.Info.Open(FileMode.Open, FileAccess.Read), "application/octet-stream", file.Name);
        }

        [HttpPost]
        public JsonResult DeleteFile(int ID)
        {
            //try
            //{
            //#Data
            var file = UOW.FS_Items.FirstOrDefault(e => e.ID == ID);

            //#Permission
            if (!permissionServices.CanUpload(CurrentUser, file.Root))
            {
                return new ViewModelItems(this, false, "CanOpen permission error")
                {
                    PermissionError = true
                }.ToJson;
            }

            UOW.Delete(file);
            //}
            //catch (Exception ex)
            //{
            //var json_err = new DeleteResult(false, ex.Message);

            //return Json(json_err, JsonRequestBehavior.AllowGet);
            // }

            return new DeleteResult(this, true, "").ToJson;
        }



        [HttpGet]
        public async Task<JsonResult> ScanDirectory(int ID)
        {
            if (ID == -1)
            {
                var dir = UOW.Repo_SRootDirectory.All_List;
                new ConfigurationServices(UOW, ConfigTools).
                    ReadConfiguration();
                await new ScanServices(UOW).ScanAllDirs();
            }
            else
            {
                var dir = UOW.Repo_SDirectory.All.
                    FirstOrDefault(e => e.ID == ID);
                await new ScanServices(UOW).
                    RecursScanDirectoryAsync(dir, false);


                //var items = UOW.context.FS_Items.
                //    FirstOrDefault(e => e.ID == ID).Items.ToList();
            }

            return new BaseApiResult(this, true, "").ToJson;
        }



        [HttpPost]
        public JsonResult MoveElement(int ID, int NewParent)
        {
            //Перемещаемый элемент
            var elem = UOW.FS_Items.FirstOrDefault(e => e.ID == ID);
            //Папка в которую будет выполняться перемещение
            var new_parent = UOW.Repo_SDirectory.All.FirstOrDefault(e => e.ID == NewParent);


            if (!permissionServices.CanUpload(CurrentUser, elem.Parent) ||
                !permissionServices.CanUpload(CurrentUser, new_parent))
            {
                return new BaseApiResult(this, false, "").ToJson;
            }

            elem.Parent = new_parent;
            UOW.Update(elem);

            return new BaseApiResult(this, true, "").ToJson;
        }

        [HttpPost]
        public JsonResult CreateDirectory(int ParentID, string Name)
        {
            //#Data
            var parent = UOW.Repo_SDirectory.All.
                FirstOrDefault(e => e.ID == ParentID);

            //#Permission
            if (!permissionServices.CanUpload(CurrentUser, parent))
            {
                return new BaseApiResult(this, false, "").ToJson;
            }

            UOW.Repo_SDirectory.
                Create(new SDirectory((SDirectory)parent, Name, CurrentUser));

            return new BaseApiResult(this, true, "").ToJson;
        }

    }
}