﻿
import React from 'react';
import { Form, Button, Alert } from 'react-bootstrap'

import Notification from '../../Tools/Notification'

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'



export default class UserControl extends BaseControl {

    constructor(props) {
        super(props, "UserControl");

        this.state = { UserName: "" };//, AuthResult: "" };
        this.authServices = new AuthServices();

        if (this.authServices.IsAuth())
            this.authServices.GetUserInfoAsync().then(function (data) {

                if (data.Successe) {
                    this.setState({ UserName: data.UserName });// AuthResult: "" });
                    this.EventRegister.EventAction("OnAuthChange");
                }
                else {
                    this.setState({ UserName: "" });//, AuthResult: data.ResMsg });
                    Notification.MesEr(data.ResMessage, "Auth");
                }

            }.bind(this));
    }

    //Кнопка входа
    AuthClick() {
        let login = this.refs.Login.value;
        let password = this.refs.Password.value;

        this.authServices.AuthAsync(login, password)
            .then(function (data) {

                if (data.Successe) {
                    this.setState({ UserName: data.UserName });//, AuthResult: "" });
                    this.EventRegister.EventAction("OnAuthChange");
                }
                else {
                    this.setState({ UserName: "" });//, AuthResult: data.ResMsg });
                    Notification.MesEr(data.ResMessage, "Auth");
                }

            }.bind(this));
    }

    //Кнопка выхода
    LogoutClick() {
        this.authServices.Logout();
        this.setState({ UserName: "" });//, AuthResult: "" });

        this.EventRegister.EventAction("OnAuthChange");
    }


    render() {
        let state = this.state;

        return (
            <div>
                {this.authServices.IsAuth()
                    ?
                    <div>                       
                        <Alert variant="success">Вы авторизованы. Пользователь: {state.UserName}.</Alert>
                        <Button onClick={this.LogoutClick} variant="danger">Выход</Button>
                    </div>
                    :
                    <div>
                        <Alert variant="warning">Вы не авторизованы. <b>Вход:</b></Alert>
                        {/*{state.AuthResult != "" ? <p>{state.AuthResult}</p> : ""}*/}

                        {/*<Form.Label>Email address</Form.Label>*/}
                        <Form.Control ref="Login" type="text" placeholder="Enter login" />
                        <Form.Text className="text-muted">
                            We'll never share your login with anyone else.
                        </Form.Text>
                        <br />
                        {/*<Form.Label>Password</Form.Label>*/}
                        <Form.Control ref="Password" type="password" placeholder="Password" />
                        <br />
                        <Button onClick={this.AuthClick} variant="success">Авторизация</Button>
                    </div>
                }
            </div>
        );
    }
}
