﻿
import React from 'react';
import { Route, Switch } from 'react-router-dom';

import BaseControl from './BaseControl.jsx'
import FileExplorerPage from './Pages/FileExplorerPage.jsx'
import AdministratorPage from './Pages/AdministratorPage.jsx'
import UserPage from './Pages/UserPage.jsx'

export default class RouteSystem extends BaseControl {

    constructor(props) {
        super(props, "RouteSystem");
    }

    render() {
        return (
            <Switch>
                <Route ref="CurrentPage" exact path="/" component={FileExplorerPage} />
                <Route ref="CurrentPage" exact path="/App" component={FileExplorerPage} />
                <Route ref="CurrentPage" exact path="/index.html" component={FileExplorerPage} />
                <Route ref="CurrentPage" path="/?ID=:ID" component={FileExplorerPage} />
                <Route ref="CurrentPage" path="/Admin" component={AdministratorPage} />
                <Route ref="CurrentPage" path="/User" component={UserPage} />
            </Switch>
        );
    }
}
