﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Data.Entity;

using Model.Entities.Users;
using Model.Entities.Files;
using Model.Entities.Files.FS_Entities;
using Model.UnitsOfWork;

using BLL.Services.System;
using Model.ViewModel.Files;

namespace BLL.Services.Mapper
{
    public class ExplorerMapper : Base.BaseServices
    {
        readonly PermissionServices PermissionServices;
        readonly Func<User> CurrentUser;

        public ExplorerMapper(UOW UOW, 
            PermissionServices permissionServices,
            Func<User> user) : base(UOW)
        {
            this.PermissionServices = permissionServices;
            this.CurrentUser = user;
        }

        protected List<SDirectory> GetDirecoryData(int ID)
        {
            if (ID == -1)
            {
                //#Data #Permission
                //Выбрать корренные папки, к которым имеет доступ текущий пользователь
                return UOW.Repo_SRootDirectory.All_NoTrack_List.
                    Where(e => PermissionServices.CanOpen(CurrentUser(), e))
                    .Cast<SDirectory>()
                    .ToList();
            }
            else
            {
                //#Data
                return UOW.Repo_SDirectory.All_NoTrack.
                    Where(e => e.ID == ID)
                    .Include(e => e.Root)
                    .Include("_Items")
                    .ToList();
                    //First();
            }
        }

        public List<ExplorerItem> GetDirectoryItems(int ID)
        {
            if (ID == -1)
            {
                return GetDirecoryData(ID).
                        Select(e => new ExplorerItem()
                        {
                            ID = e.ID,
                            Name = e.Name,
                            Type = e.Type.ToString(),
                            Size = -1
                        }).ToList();
            }
            else
            {
                return GetDirecoryData(ID).First().Items.Where(e => e.Type != Enum_BaseDirectoryEntity.UploadFile).
                    Select(e => new ExplorerItem()
                    {
                        ID = e.ID,
                        Name = e.Name,
                        Type = e.Type.ToString(),
                        Size = (e is SFile) ? e.GetSize(Enum_FileSize.MByte) : -1
                    }).ToList();
            }
        }

        //Формирование пути навигации
        public List<PathItem> GetPath(int ID)
        {
            if (ID == -1)
            {
                return PathItem.GetDefault();
            }
            else
            {
                return PathItem.GetDefault().Concat(
                        GetDirecoryData(ID).First().LogicPath2.
                        Select(e => new PathItem()
                        {
                            ID = e.ID,
                            Name = e.Name
                        })).ToList();
            }            
        }

    }
}
