﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml.Serialization;

namespace Model.Tools
{
    [Serializable]
    public class ConfigData
    {
        public DateTime LastExportDate;
        public bool WriteNewRootDir { set; get; } = true;
        public List<string> RootDirs { set; get; } = new List<string>();
        //{@"D:\GIT\WebFileServer\FileServer\Console\bin\Debug\Dir1" };
    }

    public class ConfigTools
    {
        readonly string ConfName = "Config.xml";

        public string ConfigDirectory { set; get; }    
        string ConfPath => Path.Combine(ConfigDirectory, ConfName);


        public ConfigData Data { set; get; } 
        public bool HaveChanges { set; get; }

        private static ConfigTools single;


        public static ConfigTools Get()
        {
            if (single == null)
                single = new ConfigTools();

            return single;
        }


        private ConfigTools()
        {            
        }


        public void Import()
        {
            if (!File.Exists(ConfPath))
            {
                Data = new ConfigData();
                Export();

                return;
            }

            XmlSerializer formatter = new XmlSerializer(typeof(ConfigData));
            using (FileStream fs = new FileStream(ConfPath, FileMode.Open))
            {
                Data = (ConfigData)formatter.Deserialize(fs);
            }
        }
        public void Export()
        {
            Data.LastExportDate = DateTime.Now;

            XmlSerializer formatter = new XmlSerializer(typeof(ConfigData));

            using (FileStream fs = new FileStream(ConfPath, FileMode.Create))
            {
                formatter.Serialize(fs, Data);
            }
        }


    }
}
