﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;

using Model.Entities.Base;
using Model.Entities.Files;
using Model.ViewModel;

namespace Model.Entities.Users
{
    public class User : BaseEntity
    {
        [Required]
        public string Login { set; get; }
        [Required]
        public string Password { set; get; }
        public bool IsActive { set; get; }

        public bool IsAdmin
        {
            get
            {
                EnumDefaultGroups res;
                return Groups.FirstOrDefault(e => Enum.TryParse<EnumDefaultGroups>(e.Name, out res)) != null;
            }
        }

        [Obsolete]
        public User() { }

        public User(string Login, string Password, bool IsActive, IEnumerable<Group> Groups)
        {
            this.Login = Login;
            this.Password = Password;
            this.IsActive = IsActive;

           this. Groups = new List<Group>(Groups);
        }


        public virtual List<Group> Groups { set; get; } = new List<Group>();

        public virtual List<FS_Item> FS_Items { set; get; } = new List<FS_Item>();

    }
}
