﻿
import React from 'react';
import { Nav } from 'react-bootstrap'

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'
import UserListControl from '../Controls/Admin/UserListControl.jsx'
import GroupListControl from '../Controls/Admin/GroupListControl.jsx'


export default class AdministratorPage extends BaseControl {

    constructor(props) {
        super(props, "AdministratorPage");

        this.authServices = new AuthServices();
        this.state = {
            ActiveWindows: 0,
            isAuth: this.authServices.IsAuth()
        };        

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.setState({ isAuth: this.authServices.IsAuth() });
    }

    OnUsersClick() {
        this.setState({ ActiveWindows: 0 });
    }
    OnGroupsClick() {
        this.setState({ ActiveWindows: 1 });
    }


    render() {
        return (
            <div>
                {this.state.isAuth
                    ?
                    <div>
                        <Nav variant="tabs">
                            <Nav.Item>
                                <Nav.Link onClick={this.OnUsersClick}>Users</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link onClick={this.OnGroupsClick}> Groups</Nav.Link>
                            </Nav.Item>
                        </Nav>

                        {this.state.ActiveWindows == 0
                            ?                         
                                <UserListControl ref="UserListControl" />                            
                            :                            
                                <GroupListControl ref="GroupListControl" />                            
                        }
                    </div>
                    : <p>Вы не авторизованы</p>
                }

            </div>
        );
    }
}

