﻿
import React from 'react';
import { BrowserRouter as Router, Route, Switch, Link } from 'react-router-dom';
import { Nav, Navbar, NavDropdown, MenuItem, NavItem } from 'react-bootstrap'

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'


export default class MenuControl extends BaseControl {

    constructor(props) {
        super(props, "MenuControl");

        this.authServices = new AuthServices();
        this.state = { isAuth: this.authServices.IsAuth() };

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.setState({ isAuth: this.authServices.IsAuth() });
    }

    render() {
        return (
            <Navbar>
                {/* "Link" in brand component since just redirect is needed */}
                <Navbar.Brand>WebFileServer</Navbar.Brand>
                <Nav>
                    {/* "NavLink" here since "active" class styling is needed */}
                    <Nav.Link as={Link} to='/'>App</Nav.Link>
                    <Nav.Link as={Link} to='/Admin'>Admin</Nav.Link>
                    <Nav.Link as={Link} to='/User'>User</Nav.Link>
                </Nav>
            </Navbar>
        );
    }
}

