﻿
import React from 'react';
import autoBind from 'react-autobind';

import Log from '../../Tools/LogTools'

import AuthServices from '../../Services/AuthServices'


export default class AdministratorPage extends React.Component {

    constructor(props) {
        super(props);
        autoBind(this);
        Log("AdministratorPage", "start");

        this.state = { ActiveWindows: 0 };
        this.authServices = new AuthServices();
    }

    OnAuthChange() {
        this.refs.MenuControl.OnAuthChange();
    }

    OnUsersClick() {
        this.setState({ ActiveWindows: 0 });
    }
    OnGroupsClick() {
        this.setState({ ActiveWindows: 1 });
    }


    render() {
        return (
            <div>
                <hr />
                <MenuControl ref="MenuControl"
                    ParentComponent={this}
                />
                <hr />
                {this.authServices.IsAuth()
                    ?
                    <div>
                        <Nav variant="tabs">
                            <Nav.Item>
                                <Nav.Link onClick={this.OnUsersClick}> Users</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link onClick={this.OnGroupsClick}> Groups</Nav.Link>
                            </Nav.Item>
                        </Nav>

                        {this.state.ActiveWindows == 0
                            ?
                            <div>
                                UsersWindows
                            </div>
                            :
                            <div>
                                GroupsWindow
                            </div>
                        }
                    </div>
                    : <p>Вы не авторизованы</p>
                }

            </div>
        );
    }
}

