﻿
import React from 'react';
import autoBind from 'react-autobind';
import { Modal, Button } from 'react-bootstrap'

import Log from '../../../Tools/LogTools'
import Notification from '../../../Tools/Notification'

import FileExplorerServices from '../../../Services/FileExplorerServices'

import FileExplorerControl from '../FileExplorer/FileExplorerControl.jsx'


export default class ExplorerActionsControl extends React.Component {

    constructor(props) {
        super(props);
        autoBind(this);
        Log("ExplorerActionsControl", "start")

        this.state = { ResultMsg: "", MoveWindowsShow: false }
        this.fileExplorerServices = new FileExplorerServices();
    }


    OnDownloadClick(sender) {

        let selected = this.props.ParentComponent.refs.
            FileExplorerControl.GetSelectedID();

        selected.map((e) => {
            Log("ExplorerActionsControl", "OnDownload " + e);

            this.fileExplorerServices.OpenDownload(e);
        });
    }

    OnDeleteClick(sender) {

        let selected = this.props.ParentComponent.refs.
            FileExplorerControl.GetSelectedID();
        let promises = selected.map((e) => {
            Log("ExplorerActionsControl", "OnDelete " + e);
            return this.fileExplorerServices.DeleteAsync(e);
        });

        let Result = "";


        Promise.all(promises).then(function (data) {
            data.map(function (e) {
                Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";
            });

            Notification.MesOk(Result, 'Move');
            //this.setState({ ResultMsg: Result });
            this.props.
                ParentComponent.OnItemsChange();
        }.bind(this));

    }


    OnMoveClick(sender) {
        let selected = this.props.ParentComponent.refs.
            FileExplorerControl.GetSelectedID();

        if (selected.length == 0)
            return;

        this.selected = selected;

        this.setState({ MoveWindowsShow: true });
    }

    OnCreateDirectoryClick(sender) {
        //debugger;
        let dirname = this.refs.DirectoryName.value;
        let id = this.props.ParentComponent.GetID();

        let url = "/Explorer/CreateDirectory?ParentID=" + id
            + "&Name=" + dirname;

        this.fileExplorerServices.CreateDirectoryAsync(dirname, id).
            then(function (data) {
                this.props.ParentComponent.OnItemsChange();
                Notification.MesOk('Complete', 'CreateDir');
            }.bind(this));

        this.refs.DirectoryName.value = "";
    }


    OnMoveWindowCloseClick() {
        this.setState({ MoveWindowsShow: false });
    }

    GetID() {
        if (this.SelectedID != undefined)
            return this.SelectedID;

        return this.props.ParentComponent.GetID();
    }
    SetID(ID) {
        this.SelectedID = ID;
    }

    OnMoveWindowClick() {
        let promises = this.selected.map(function (e) {
            Log("ExplorerActionsControl", "OnMove " + e);
            return this.fileExplorerServices.MoveAsync(e, this.SelectedID);
        }.bind(this));

        let Result = "";
        Promise.all(promises).then(function (data) {
            Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";

            //this.setState({ ResultMsg: Result });
            Notification.MesOk(Result, 'Move');
            this.props.
                ParentComponent.OnItemsChange();
        }.bind(this));

        this.setState({ MoveWindowsShow: false });
    }


    render() {

        return (
            <div>
                <p>ExplorerControlPanel</p>

                <p>
                    <input ref="DirectoryName" />
                    <button onClick={this.OnCreateDirectoryClick}>CreateDirectory</button>
                </p>


                {this.state.ResultMsg != ""
                    ? <p>{this.state.ResultMsg}</p>
                    : ""
                }

                <table>
                    <thead>
                        <tr>
                            <th><button onClick={this.OnDownloadClick}>Скачать</button></th>
                            <th><button onClick={this.OnDeleteClick}>Удалить</button></th>
                            <th><button onClick={this.OnMoveClick}>Переместить</button></th>
                        </tr>
                    </thead>
                </table>

                <Modal ref="Modal"
                    show={this.state.MoveWindowsShow}
                    onHide={this.OnMoveWindowCloseClick}

                    size="lg"
                    aria-labelledby="contained-modal-title-vcenter"
                    centered
                >
                    <Modal.Header closeButton>
                        <Modal.Title>Select destination directory</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <FileExplorerControl ref="FileExplorerControl"
                            ParentComponent={this}
                            ShoSelect={false}
                        />
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant="secondary" onClick={this.OnMoveWindowCloseClick}>
                            Cansel
                        </Button>
                        <Button variant="primary" onClick={this.OnMoveWindowClick}>
                            Move to directory
                        </Button>
                    </Modal.Footer>
                </Modal>
            </div>
        );

    }
}
