﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.Data.Entity;

using Model.Entities.Users;
using Web.Models.Base;
using Web.Models;

namespace Web.Controllers.API
{

    public class UserController : Base.BaseApiController
    {   

        //[HttpPost]
        //public JsonResult CreateUser(string Login, string Password)
        //{
        //    UOW.Repo_User.Create(new User()
        //    {
        //        Login = Login,
        //        Password = Password,
        //        IsActive = true,
        //        Groups = new List<Group>()
        //        {
        //            UOW.Repo_Group.GetDefaultGroup(EnumDefaultGroups.Пользователи)
        //        }
        //    });

        //    return Json(true, JsonRequestBehavior.AllowGet);
        //}


        [HttpPost]
        public JsonResult GetUserList()
        {
            UserListMode json;

            if (CurrentUser.IsAdmin)
            {
                var users = UOW.Repo_User.All_NoTrack.Include(e => e.Groups).ToList();
                var groups = UOW.Repo_Group.All_NoTrack_List;
                groups.RemoveAll(e => e.Name == EnumDefaultGroups.Анонимные.ToString());

                var model = users.Select(e => new EditUserModel()
                {
                    ID = e.ID,
                    Name = e.Login,
                    Password = "",
                    Changes = EnumChanges.NoChange,
                    Active = e.IsActive,
                    Groups = groups.Select(e2 => new GroupInfo()
                    {
                        ID = e2.ID,
                        Name = e2.Name,
                        EnterInGroup = e.Groups.Contains(e2)
                    }).ToList()
                }).ToList();               


                json = new UserListMode(true)
                {
                    Users = model
                };
                
            }
            else
            {
                json = new UserListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"                    
                };
            }

            return Json(json);
        }

        [HttpPost]
        public JsonResult SetUserList(UserListMode model)
        {
            if (CurrentUser.IsAdmin)
            {
                


                return Json(true);
            }

            return Json(false);
        }

        public class UserListMode : BaseApiResult
        {
            public UserListMode(bool Successe) : base(Successe, "", "UserList") { }

            public List<EditUserModel> Users;
        }


    }
}