﻿
import React from 'react';
import autoBind from 'react-autobind';
import { Link } from 'react-router-dom';

import Log from '../../Tools/LogTools'

import AuthServices from '../../Services/AuthServices'


export default class MenuControl extends React.Component {

    constructor(props) {
        super(props);
        autoBind(this);
        Log("MenuControl", "start");

        //this.state = { counter: 0 };
        this.authServices = new AuthServices();
    }

    OnAuthChange() {
        this.forceUpdate();
    }

    render() {
        return (
            <div>

                <table>
                    <thead>
                        <tr>
                            <td>Menu:</td>
                            <td>
                                <Link to={`/`}>
                                    <button>FS</button>
                                </Link>
                            </td>

                            {this.authServices.IsAuth()
                                ?
                                <td>
                                    <Link to={`/Admin`}>
                                        <button>Admin</button>
                                    </Link>
                                </td>
                                : <td></td>
                            }
                        </tr>
                    </thead>                    
                </table>

            </div >
        );
    }
}

