﻿
import React from 'react';
import autoBind from 'react-autobind';

import Log from '../../Tools/LogTools'
import Configuration from '../../Tools/Configuration'

import MenuControl from '../Controls/MenuControl.jsx'
import UserControl from '../Controls/UserControl.jsx'
import FileExplorerControl from '../Controls/FileExplorer/FileExplorerControl.jsx'
import ExplorerActionsControl from '../Controls/FileExplorer/ExplorerActionsControl.jsx'
import UploaderControl from '../Controls/FileExplorer/UploaderControl.jsx'
import BootstrapControl from '../Controls/BootstrapControl.jsx'


export default class FileExplorerPage extends React.Component {

    constructor(props) {
        super(props);
        autoBind(this);
        Log("FileExplorerPage", "start");

        //this.state = { counter: 0 };

        //Получить ID из url
        var Url_ID = new URL(window.location.href).
            searchParams.get("ID");

        if (Url_ID != null)
            this.SetID(Url_ID);
        //if (this.props.match != undefined
        //    && this.props.match.params != undefined
        //    && this.props.match.params.ID != undefined)
        //    this.SetID(this.props.match.params.ID);
        //Получить id от родительского компонента
        else
            this.SetID(-1);
    }


    OnAuthChange() {
        this.OnItemsChange();
        this.refs.MenuControl.OnAuthChange();
    }
    OnItemsChange() {
        this.refs.FileExplorerControl.
            LoadDirectory();
    }

    SetID(val) {
        this.CurrentID = val;
        Log("FileExplorerPage", this.CurrentID);
    }

    GetID() {
        return this.CurrentID;
    }


    render() {
        return (
            <div>
                <hr />
                <MenuControl ref="MenuControl"
                    ParentComponent={this}
                />
                <hr />
                <UserControl ref="UserControl"
                    ParentComponent={this}
                />

                <hr />
                <FileExplorerControl ref="FileExplorerControl"
                    ParentComponent={this}
                    ShoSelect={true}
                />
                <hr />
                {this.GetID() != Configuration.RooDirectoryID
                    ?
                    <div>                        
                        <ExplorerActionsControl ref="ExplorerActionsControl"
                            ParentComponent={this}
                        />
                        <hr />
                        <UploaderControl ref="UploaderControl"
                            ParentComponent={this}
                        />
                        <hr />
                    </div>
                    : ""
                }
                <BootstrapControl />
                <hr />

            </div>
        );
    }
}

