﻿
import ApiQuery from '../Tools/ApiQuery'


export default class UserServices {

    constructor() {
        this.URL_GetUsers = "api/User/GetUserList";
        this.URL_SetUsers = "api/User/SetUserList";
    }


    async GetUsersAsync() {
        return await ApiQuery(this.URL_GetUsers, "Post")
            .then(function (data) {
                return data;
            });
    }

    async SetUsersAsync(users) {

        return await ApiQuery(this.URL_SetUsers, "Post", users)
            .then(function (data) {
                return data;
            }.bind(this));
    }

}
