﻿
import React from 'react';
import autoBind from 'react-autobind';
import { Nav } from 'react-bootstrap'

import Log from '../../Tools/LogTools'

import AuthServices from '../../Services/AuthServices'

import MenuControl from '../Controls/MenuControl.jsx'
import UserListControl from '../Controls/Admin/UserListControl.jsx'


export default class AdministratorPage extends React.Component {

    constructor(props) {
        super(props);
        autoBind(this);
        Log("AdministratorPage", "start");

        this.state = { ActiveWindows: 0 };
        this.authServices = new AuthServices();
    }

    OnAuthChange() {
        this.refs.MenuControl.OnAuthChange();
    }

    OnUsersClick() {
        this.setState({ ActiveWindows: 0 });
    }
    OnGroupsClick() {
        this.setState({ ActiveWindows: 1 });
    }


    render() {
        return (
            <div>
                <hr />
                <MenuControl ref="MenuControl"
                    ParentComponent={this}
                />
                <hr />
                {this.authServices.IsAuth()
                    ?
                    <div>
                        <Nav variant="tabs">
                            <Nav.Item>
                                <Nav.Link onClick={this.OnUsersClick}>Users</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link onClick={this.OnGroupsClick}> Groups</Nav.Link>
                            </Nav.Item>
                        </Nav>

                        {this.state.ActiveWindows == 0
                            ?
                            <div>
                                <UserListControl ref="UserListControl" />
                            </div>
                            :
                            <div>
                                GroupsWindow
                            </div>
                        }
                    </div>
                    : <p>Вы не авторизованы</p>
                }

            </div>
        );
    }
}

