﻿
import React from 'react';
import autoBind from 'react-autobind';
import { Link } from 'react-router-dom';

import Log from '../../../Tools/LogTools'
import Configuration from '../../../Tools/Configuration'
import ArrayCompare from '../../../Tools/Sort'


import FileExplorerServices from '../../../Services/FileExplorerServices'

import FileExplorerRow from './FileExplorerRow.jsx'


export default class FileExplorerControl extends React.Component {

    constructor(props) {
        super(props);
        autoBind(this);
        Log("FileExplorerControl", "start");


        this.state = { data: {}, ShoSelect: this.props.ShoSelect };
        this.ChildRows = [];
        this.fileExplorerServices = new FileExplorerServices();


        this.LoadDirectory();
    }

    //#endregion 

    //#region Events

    OnBackClick(sender) {
        this.props.ParentComponent.SetID(this.state.data.ParentID);
        Log("FileExplorerControl", "OnBackClick " + this.state.data.ParentID);

        //this.state = { ID: new_id };
        this.LoadDirectory();
    }

    OnDirectoryClick(id) {
        this.props.ParentComponent.SetID(id);
        Log("FileExplorerControl", "MoveToDirectory " + id);


        //this.state = { ID: new_id };
        this.LoadDirectory();
    }

    OnSortClick(sender) {
        let SortProperty = sender.target.attributes[0].value;

        let data = this.state.data;
        //debugger;
        data.items.sort(ArrayCompare(SortProperty, 1));
        this.setState({ data: data });
    }


    //#endregion

    //Загружает информацию о текущей папке
    LoadDirectory() {
        let ID = this.props.ParentComponent.GetID();
        Log("FileExplorerControl", "LoadDirectory " + ID);

        this.fileExplorerServices.DirectoryGetItemsAsync(ID)
            .then(function (data) {
                this.setState({ data: data, ShoSelect: (this.props.ShoSelect && ID != -1 ? true : false) });
            }.bind(this));
    }

    OnScanDirClick(sender) {
        let ID = this.props.ParentComponent.GetID();
        Log("FileExplorerControl", "ScanDirectory " + ID);

        this.fileExplorerServices.ScanDirectoryAsync(ID).
            then(function (data) {
                this.LoadDirectory();
            }.bind(this));
    }

    //Получить ID данных выбранных строк
    GetSelectedID() {
        //debugger;
        return this.ChildRows.
            filter(e => e.IsCheked()).
            map(e => e.GetDataID());
    }

    render() {
        let data = this.state.data;

        //Если данные не пусты
        if (JSON.stringify(data) !== '{}') {
            Log("FileExplorerControl", "Data");

            return (
                <div>
                    {this.props.ParentComponent.GetID() != Configuration.RooDirectoryID
                        ?
                        <p>
                            <Link to={`/?ID=${data.ParentID}`}>
                                <button onClick={this.OnBackClick}>
                                    l-  На уровень вверх - {data.ParentName}
                                </button>
                            </Link>
                        </p>
                        : null
                    }


                    <p>{data.LogicPath}</p>
                    <p>
                        <button onClick={this.LoadDirectory}>
                            Update
                         </button>
                        <button onClick={this.OnScanDirClick}>
                            Rescan
                         </button>
                    </p>


                    <table>

                        <thead>
                            <tr>
                                <th>
                                    <button property="ID" onClick={this.OnSortClick}>ID</button>
                                </th>
                                {
                                    this.state.ShoSelect
                                        ? <th>Select</th>
                                        : null
                                }
                                <th>
                                    <button property="Name" onClick={this.OnSortClick}>Name</button>
                                </th>
                                <th>
                                    <button property="Type" onClick={this.OnSortClick}>Type</button>
                                </th>
                                <th>
                                    <button property="Size" onClick={this.OnSortClick}>Size</button>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            {
                                data.items.map(function (elem, i, arr) {
                                    return [
                                        <FileExplorerRow ref={row => {
                                            if (row != null) this.ChildRows[i] = row;
                                            else this.ChildRows.splice(i, 1);
                                        }}
                                            ShoSelect={this.state.ShoSelect}
                                            key={i}
                                            ID={i}
                                            data={elem}
                                            ParentComponent={this}
                                        />
                                    ];
                                }.bind(this))
                            }
                        </tbody>                     
                        
                    </table>
                </div>
            );
        }
        else {
            Log("FileExplorerControl", "NoData");

            return (
                <div>
                    <p>NoData</p>
                </div>
            );
        }
    }
}