﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Data.Entity;

using Model.Entities.Users;
using Model.Entities.Files;
using Model.Entities.Files.FS_Entities;

namespace Model.UnitsOfWork
{
    public class Context : 
        DbContext
    {
        static string log = "Context.log";

        static Context()
        {
            File.Delete(log);
        }

        public DbSet<User> Users { set; get; }
        public DbSet<Group> Groups { set; get; }


        public DbSet<FS_Item> FS_Items { set; get; }
        public DbSet<SRootDirectory> SRootDirectories { set; get; }
        public DbSet<SDirectory> SDirectories { set; get; }
        public DbSet<SFile> SFiles { set; get; }
        public DbSet<SFileUpload> SFileUploads { set; get; }



        public Context(bool Clear = false) : base("DBConnection")
        {
            Database.Log = (s) =>
            {
                //using (FileStream stream = new FileStream(log, FileMode.Append))
                //{
                //    using (StreamWriter wr = new StreamWriter(stream))
                //    {
                //        wr.WriteLine(s);
                //    }
                //}
            };

            if (Clear && Database.Exists())
            {
                Database.Connection.Close();
                Database.Delete();
            }
        }
    }
}
