﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Diagnostics;
using System.Windows.Forms;

namespace NodeStarterTools
{
    /// <summary>
    /// dev or build
    /// if (build) copy bundle to mvc
    /// </summary>
    class Program
    {

        /// <summary>
        /// Запускать SPA часть
        /// </summary>
        static readonly bool RunSPA = true;


        /// <summary>
        /// Не самый лучший критерий проверки (По имени npm)
        /// Проверка есть ли npm окно при запуске debug dev
        /// </summary>
        enum EnumDevMode
        {
            NoCheckExists, //Не проверять
            IfExistsNoRun, //Если процесс присутствует, то не запускать
            IfExistsReload //Если процесс пресутствует, то перезапустить
        }

        static EnumDevMode enumDevMode = EnumDevMode.IfExistsNoRun;

        #region

        /// <summary>
        /// Путь к bin\*\
        /// </summary>
        static readonly DirectoryInfo AppPath = new DirectoryInfo(Path.GetDirectoryName(Application.ExecutablePath));

        /// <summary>
        /// Папка этого проекта
        /// </summary>
        static readonly DirectoryInfo ThisProject = AppPath.Parent.Parent;
        /// <summary>
        /// Папка решения
        /// </summary>
        static readonly DirectoryInfo Solution = ThisProject.Parent;


        /// <summary>
        /// Папка SPA проекта
        /// </summary>
        static readonly DirectoryInfo SPAProject = new DirectoryInfo(Solution.FullName+@"\SPA");

        /// <summary>
        /// Папка в которой находится бандл
        /// </summary>
        static readonly DirectoryInfo SPAProjectBuild = new DirectoryInfo(SPAProject.FullName + @"\Build");
        /// <summary>
        /// Папка, в которую размещается Release js бандла
        /// </summary>
        static readonly DirectoryInfo WebProjectScripts = new DirectoryInfo(Solution.FullName + @"\Web\Scripts");

        #endregion


        #region

        static void Debug()
        {
            Console.WriteLine("Run SPA dev");

            ProcessStartInfo dev = new ProcessStartInfo()
            {
                FileName = SPAProject.FullName + @"\dev.bat",
                WorkingDirectory = SPAProject.FullName,
                CreateNoWindow = false,
                WindowStyle = ProcessWindowStyle.Normal
            };

            Process.Start(dev);//.WaitForExit();
        }

        static void Release()
        {
            Console.WriteLine("Run SPA build");

            ProcessStartInfo build = new ProcessStartInfo()
            {
                FileName = SPAProject.FullName + @"\build.bat",
                WorkingDirectory = SPAProject.FullName,
                CreateNoWindow = false,
                WindowStyle = ProcessWindowStyle.Normal
            };
            Process.Start(build).WaitForExit();


            //Файлы для копирования
            var files = new string[] 
            {
                //Bundle
                "app_bundle.js",
                //Sourse map
                "app_bundle.js.map"
            };


            foreach (var elem in files)
            {
                string src_path = SPAProjectBuild.FullName + "\\" + elem;
                string dst_path = WebProjectScripts.FullName + "\\" + elem;

                //Копирование в mvc проект
                Console.WriteLine("Copy {0} {1}", src_path, dst_path);
                File.Copy(src_path, dst_path, true);
            }
        }

        #endregion

        static void Main(string[] args)
        {
            if (!RunSPA)
                return;
            
            //true - запущен при сборке из VS
            bool RunFromVSBuild = args.Length != 0;


#if DEBUG
            //Запущен при пуске проета
            if (!RunFromVSBuild)
            {
                Console.WriteLine("Run from debug VS");

                switch (enumDevMode)
                {
                    case EnumDevMode.NoCheckExists:
                        Console.WriteLine("EnumDevMode.NoCheckExists");

                        Debug();
                        break;

                    case EnumDevMode.IfExistsNoRun:
                        Console.WriteLine("EnumDevMode.NoCheckExists");

                        if (Process.GetProcesses().
                            Where(e => e.MainWindowTitle == "npm").
                            Count() == 0)
                            Debug();
                        break;

                    case EnumDevMode.IfExistsReload:
                        Console.WriteLine("EnumDevMode.IfExistsReload");

                        Process.GetProcesses().
                            Where(e => e.MainWindowTitle == "npm").
                            ToList().ForEach(e => e.CloseMainWindow());
                        Debug();
                        break;
                }

                
            }
            //запущена при сборке
            else
            {
                Console.WriteLine("Run from debug build");
            }
#else
                        if (!RunFromVSBuild)
                        {
                            Console.WriteLine("Run from release VS");
                            //Не требуется так как сработает событие окончания сборки
                            //Release();
                        }
                        else
                        {
                            Console.WriteLine("Run from release build");
                            Release();
                        }    
#endif

        }
    }
}
