﻿
import React from 'react';
import { ReactTabulator } from 'react-tabulator'
import { Modal, Button } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import UserServices from '../../../Services/UserServices'

import BaseControl from '../../BaseControl.jsx'

export default class GroupListConrol extends BaseControl {

    constructor(props) {
        super(props, "UserListControl");

        this.userServices = new UserServices();

        this.state = {
            Groups: [],
            ShoPermissions: false,
            //Заглушка
            GroupPermissions: this.userServices.CreateStubGroup()
        };        
        

        this.columns = [
            { title: "ID", field: "ID" },
            { title: "Name", field: "Name", editor: "input" },

            { title: "Permissions", formatter: this.ButtonFormatter, align: "center", cellClick: this.OnPermissionsClick },
            { title: "Delete", formatter: this.ButtonFormatter, align: "center", cellClick: this.DeleteGroupClick },
        ];

        this.columns_permission = [
            { title: "ID", field: "ID" },
            { title: "Name", field: "Name" },
            { title: "CanDownload", field: "CanDownload", editor: "tick" },
            { title: "CanUpload", field: "CanUpload", editor: "tick" },
            { title: "CanOpen", field: "CanOpen", editor: "tick" },

        ];

        this.DownloadGroups();
    }

    DownloadGroups() {
        this.userServices.GetGroupsAsync().
            then(function (data) {
                let groups = data.Groups;
                this.RootDirs = data.RootDirs;
                this.setState({ Groups: groups });
            }.bind(this));
    }
    UploadGroups() {
        this.userServices.SetGroupsAsync(this.state.Groups).
            then(function (data) {
                if (data.Successe)
                    Notification.MesOk(data.ResMessage, "Save");
                else
                    Notification.MesEr(data.ResMessage, "Save");

                this.DownloadGroups();
            }.bind(this));
    }

    //custom formatter definition
    ButtonFormatter(cell, formatterParams, onRendered) { //plain text value
        return "<i class='fa fa-print'><button>Action</button></i>";
    };

    OnCellChange(cell) {
        let groups = this.state.Groups;

        let row = cell.getRow();
        let ID = row._row.data.ID;

        var data_row = groups.filter(e => e.ID === ID)[0];

        //Если NoChange то Update
        if (data_row.Changes === 0)
            data_row.Changes = 1;
    }

    OnCellChange_Permission(cell) {

        //Если NoChange то Update
        if (this.state.GroupPermissions.Changes === 0)
            this.state.GroupPermissions.Changes = 1;
    }

    UpdateClick() {
        this.DownloadGroups();
    }


    CreateGroupClick() {
        let new_group = this.userServices.CreateGroup();

        let groups = this.state.Groups;
        groups.push(new_group);

        this.setState({ Groups: groups });
    }

    DeleteGroupClick(e, cell) {
        //let table = this.refs.table.table;
        let row = cell.getRow();
        let ID = row._row.data.ID;

        let groups = this.state.Groups;

        let group = groups.filter(e => e.ID === ID)[0];

        if (group.Changes === 2) {
            groups.splice(groups.findIndex(e => e.ID === ID), 1);
        }
        else {
            group.Changes = 3;
        }

        this.setState({ Groups: groups });
    }

    OnPermissionsClick(e, cell) {
        let row = cell.getRow();
        let ID = row._row.data.ID;

        let groups = this.state.Groups;

        let group = groups.filter(e => e.ID === ID)[0];

        this.setState({ ShoPermissions: true, GroupPermissions: group });
    }
    OnPermissionsClose() {
        this.setState({ ShoPermissions: false });
    }    

    render() {
        return (
            <div>
                <button onClick={this.CreateGroupClick}>CreateGroup</button>
                <button onClick={this.DownloadGroups}>Update(Изменения будут утеряны)</button>
                <button onClick={this.UploadGroups}>SaveChanges</button>


                <ReactTabulator ref="table"
                    data={this.state.Groups.filter(e => e.Changes != 3)}
                    columns={this.columns}
                    tooltips={true}
                    layout={"fitData"}

                    cellEdited={this.OnCellChange}
                />

                <Modal ref="Modal"
                    show={this.state.ShoPermissions}
                    onHide={this.OnPermissionsClose}

                    size="lg"
                    aria-labelledby="contained-modal-title-vcenter"
                    centered
                >
                    <Modal.Header closeButton>
                        <Modal.Title>User Groups: {this.state.GroupPermissions.ID + " " + this.state.GroupPermissions.Name}</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <ReactTabulator ref="table_UserGroups"
                            data={this.state.GroupPermissions.RootDirs}
                            columns={this.columns_permission}
                            tooltips={true}
                            layout={"fitData"}

                            cellEdited={this.OnCellChange_Permission}
                        />
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant="secondary" onClick={this.OnPermissionsClose}>
                            Close
                        </Button>
                    </Modal.Footer>
                </Modal>

            </div>
        );
    }
}

