﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Data.Entity;

using BLL.Base;

using Model.UnitsOfWork;
using Model.Entities.Files.FS_Entities;

namespace BLL.Services
{
    public class GarbageUploadServices : BaseServices
    {
        readonly static TimeSpan UploadDeadTimeout = new TimeSpan(0, 5, 0);

        public GarbageUploadServices(UOW UOW) : base(UOW) { }


        public async Task<int> DeleteDeadAsync()
        {
            return await Task.Run(() => DeleteDead());
        }

        /// <summary>
        /// Выполняет удаление
        /// </summary>
        /// <returns></returns>
        public int DeleteDead()
        {
            var now = DateTime.Now;

            var dead_uploads = UOW.Repo_SFileUpload.All_List.
                Where(e => (e.LastChunkUploaded - now) > UploadDeadTimeout);

            foreach (var elem in dead_uploads)
                UOW.Repo_SFileUpload.Delete(elem);

            return dead_uploads.Count();
        }

    }
}
