﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Data.Entity;

using Model.Entities.Base;
using Model.Entities.Files;
using Model.UnitsOfWork;


namespace Model.Entities.Base
{
    public abstract class BaseRepository<T> where T : BaseEntity
    {
        public readonly Context context;

        public BaseRepository(Context context)
        {
            this.context = context;
        }


        protected DbSet<T> Set => context.Set<T>();
        public IQueryable<T> All => Set.AsQueryable();
        public IQueryable<T> All_NoTrack => Set.AsNoTracking().AsQueryable();

        public List<T> All_List => Set.ToList();
        public List<T> All_NoTrack_List => Set.AsNoTracking().ToList();


        protected abstract void Validation_Create(T elem);
        public virtual T Create(T elem)
        {
            Validation_Create(elem);

            var res = Set.Add(elem);
            context.SaveChanges();

            return res;
        }


        protected abstract void Validation_Update(T old, T elem);
        public virtual void Update(T elem)
        {           
            var change_entity = Set.FirstOrDefault(e => e.ID == elem.ID);

            if (change_entity == null)
                throw new Exception("old value not found");

            Validation_Update(change_entity, elem);

            context.Entry(change_entity).CurrentValues.SetValues(elem);
            context.SaveChanges();
        }


        protected abstract void Validation_Delete(T elem);
        public virtual void Delete(T elem)
        {
            Validation_Delete(elem);

            Set.Remove(elem);
            context.SaveChanges();
        }
        

    }
}
