﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Model.Entities.Base;
using Model.Entities.Files.FS_Entities;
using Model.UnitsOfWork;

namespace Model.Entities.Files.Repo
{
    public class Repo_SFile : Base_FS_Repository<SFile>
    {
        public Repo_SFile(Context context) : base(context) { }


        protected override void Validation_Create(SFile elem)
        {
            if (string.IsNullOrEmpty(elem.Name))
                throw new Repo_Exception<SFile>(this, elem, "elem name is null or empty");

            if (elem.Parent == null)
                throw new Repo_Exception<SFile>(this, elem, "parent is null");

            if (elem.Parent.ContainsName(elem))
                throw new Repo_Exception<SFile>(this, elem, "parent");

            if (!File.Exists(elem.PhysicalPath))
                throw new Exception();
        }

        protected override void Validation_Update(SFile old, SFile elem)
        {
            if (elem.Parent == null)
                throw new Exception();

            if (old.Name != elem.Name)
            {
                if (elem.Parent.ContainsName(elem))
                    throw new Exception();

                File.Move(old.PhysicalPath, elem.PhysicalPath);
            }
        }

        protected override void Validation_Delete(SFile elem)
        {
            File.Delete(elem.PhysicalPath);
        }




        public FileStream GetFile(SFile elem)
        {
            return new FileStream(elem.PhysicalPath, FileMode.Open);
        }

    }
}
