﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.ComponentModel.DataAnnotations.Schema;

using Model.Entities.Base;
using System.Numerics;

namespace Model.Entities.Files.FS_Entities
{
    //[NotMapped]
    public class SFile : FS_Item
    {
        //[Column("Size_string")]
        //public string Size_string { set => _Size = BigInteger.Parse(value); get => _Size.ToString(); }

        [Column("Size")]
        public long _Size { set; get; }

        public override IReadOnlyList<FS_Item> Items => new List<FS_Item>();
        public override BigInteger Size => _Size;
        public override bool IsFile => true;


        [NotMapped]
        private FileInfo _Info;
        public FileInfo Info
        {
            get
            {
                if (_Info == null)
                    _Info = new FileInfo(PhysicalPath);
                return _Info;
            }
        }


        [Obsolete]
        public SFile() { }

        public SFile(SDirectory parent, string Name, long size) : base(Enum_BaseDirectoryEntity.File, parent, Name)
        {
            this._Size = size;
        }
        protected SFile(Enum_BaseDirectoryEntity type, SDirectory parent, string Name, long size) : base(type, parent, Name)
        {
            this._Size = size;
        }
    }
}
