﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Numerics;
using System.ComponentModel.DataAnnotations.Schema;

using Model.Entities.Base;
using Model.Entities.Files.FS_Entities;

namespace Model.Entities.Files.FS_Entities
{
    public class SFileUpload : SFile
    {

        #region

        [Column("LastChunkUploaded", TypeName = "datetime2")]
        public DateTime LastChunkUploaded { set; get; }

        //[Column("UploadedSize")]
        public long UploadedSize { set; get; }
        //[Column("ChunkSize")]
        public int ChunkSize { protected set; get; }

        #endregion


        public int NextChunkNumber => (int)UploadedSize / ChunkSize;
        public int NextChunkSize => (int)((UploadedSize + ChunkSize <= Size) 
            ? ChunkSize 
            : Size - UploadedSize);
        public int UploadProgress => (int)(UploadedSize * 100 / Size);

        [NotMapped]
        public byte[] CurrentChunk { set; get; }


        [Obsolete]
        public SFileUpload() { }


        public SFileUpload(SDirectory parent, string name, long size, int ChunkSize) : base(Enum_BaseDirectoryEntity.UploadFile, parent, name, size)
        {
            this.ChunkSize = ChunkSize;
        }

    }
}
