﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml.Serialization;
using System.ComponentModel.DataAnnotations.Schema;

using Model.Entities.Base;
using Model.Entities.Users;

namespace Model.Entities.Files.FS_Entities
{
    public class Permission
    {
        public int GroupID { set; get; }
        [XmlIgnore]
        public Group Group { set; get; }

        public bool CanRead { set; get; }
        public bool CanWrite { set; get; }
        public bool CanOpen { set; get; }
    }

    public class DirectoryPermissions
    {
        public List<Permission> Permissions { private set; get; } = new List<Permission>();

        public string Export()
        {
            XmlSerializer formatter = new XmlSerializer(typeof(Permission[]));

            using (StringWriter wr = new StringWriter())
            {
                formatter.Serialize(wr, Permissions.ToArray());
                return wr.ToString();
            }
        }
        public void Import(string val)
        {
            XmlSerializer formatter = new XmlSerializer(typeof(Permission[]));

            using (StringReader rd = new StringReader(val))
            {
                Permissions = new List<Permission>(
                    (Permission[])formatter.Deserialize(rd));
            }
        }
    }



    public class SRootDirectory : SDirectory
    {
        /// <summary>
        /// Укащывается путь к папке
        /// </summary>
        public string _PhysicalPath { set; get; }


        [Column("XML_Permissions")]
        public string XML_Permissions
        {
            set => DirectoryPermissions.Import(value);
            get => DirectoryPermissions.Export();
        }
        public DirectoryPermissions DirectoryPermissions = new DirectoryPermissions();


        public override string PhysicalPath => _PhysicalPath;
        public override string LogicPath => Path.Combine("\\", Name);



        [Obsolete("")]
        public SRootDirectory() { }

        public SRootDirectory(string Path, string Name) : base(Enum_BaseDirectoryEntity.RootDirectory, null, Name)
        {
            this._PhysicalPath = Path;
        }

    }
}
