﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Model.Entities.Base;
using Model.Entities.Files.FS_Entities;
using Model.Entities.Users;
using Model.UnitsOfWork;

namespace Model.Entities.Files.Repo
{

    public class Repo_SRootDirectory : Base_FS_Repository<SRootDirectory>
    {
        public Repo_SRootDirectory(Context context) : base(context) { }


        protected override void Validation_Create(SRootDirectory elem)
        {
            if (string.IsNullOrEmpty(elem.Name))
                throw Repo_Exception<SRootDirectory>.Factory(this, elem, Repo_Exceptions.Name_is_null_or_empty);

            if (elem.Parent != null)
                throw Repo_Exception<SRootDirectory>.Factory(this, elem, Repo_Exceptions.Parent_is_null);

            if (All.FirstOrDefault(e => e.Name == elem.Name) != null)
                throw new Repo_Exception<SRootDirectory>(this, elem, "Root directory name already exist");

            try
            {
                Directory.CreateDirectory(elem.PhysicalPath);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        protected override void Validation_Update(SRootDirectory old, SRootDirectory elem)
        {
            if (elem.Parent != null)
                throw new Exception();

            if (old.Name != elem.Name && All.FirstOrDefault(e => e.Name == elem.Name) != null)
            {                
                throw new Exception();
            }

            try
            {
                Directory.Move(old.PhysicalPath, elem.PhysicalPath);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        protected override void Validation_Delete(SRootDirectory elem)
        {
            if (elem.Items.Count() != 0)
                throw new Exception();

            try
            {
                Directory.Delete(elem.PhysicalPath);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        public void DeleteInList()
        {

        }


        public void UploadGroups(DirectoryPermissions permissions)
        {
            var Group_ID = permissions.Permissions.
                Select(e => e.GroupID);

            //Select Groups from groups repo
            IEnumerable<Group> groups = context.Groups.Where(e => Group_ID.Contains(e.ID));

            foreach (var elem in permissions.Permissions)            
                elem.Group = groups.
                    FirstOrDefault(e => e.ID == elem.GroupID);            
        }

    }
}
