﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Model.Entities.Base;
using Model.UnitsOfWork;

namespace Model.Entities.Users
{
    public enum EnumDefaultGroups
    {
        Администраторы,
        Модераторы,
        Пользователи,
        Анонимные
    }

    public class Repo_Group : BaseRepository<Group>
    {
        public readonly static string[] DefaultGroupsNames = new string[]
        {
        EnumDefaultGroups.Администраторы.ToString(),
        EnumDefaultGroups.Модераторы.ToString(),
        EnumDefaultGroups.Пользователи.ToString(),
        EnumDefaultGroups.Анонимные.ToString()
        };

        public Group GetDefaultGroup(EnumDefaultGroups en)
        {
            var group = All.FirstOrDefault(e => e.Name == en.ToString());

            if (group == null)
                group = Create(new Group()
                {
                    Name = en.ToString()
                });

            return group;
        }
  


        public Repo_Group(Context context) : base(context) { }

        protected override void Validation_Create(Group elem)
        {
            if (All_NoTrack.FirstOrDefault(e => e.Name == elem.Name) != null)
                throw new Exception();
        }

        protected override void Validation_Delete(Group elem)
        {
            if (DefaultGroupsNames.Contains(elem.Name))
                throw new Exception();
        }

        protected override void Validation_Update(Group old, Group elem)
        {
            throw new NotImplementedException();
        }
    }
}

