﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.IO;
using System.Threading.Tasks;
using System.Data.Entity;

using Web.Models.Base;

using Model.Entities.Files;
using Model.Entities.Files.FS_Entities;
using BLL.Services;
using Model.UnitsOfWork;

namespace Web.Controllers
{
    class ViewModelItems : BaseApiResult
    {
        public int ParentID { set; get; }
        public string LogicPath { set; get; }
        public string ParentName { set; get; }
        public int CurrentID { set; get; }


        public List<string> Path;

        public List<ViewModelItem> items = new List<ViewModelItem>();

        public ViewModelItems(bool Successe, string ResMessage)     
            : base(Successe, ResMessage, "GetDirectoryItems") { }

    } 
    class ViewModelItem
    {
        public int ID { set; get; }
        public string Name { set; get; }
        public string Type { set; get; }
        public string Size { set; get; }
    }

    public class DeleteResult : BaseApiResult
    {
        public DeleteResult(bool Successe, string ResMessage)
             : base(Successe, ResMessage, "DeleteFile") { }
    }

    public class ExplorerController : BaseController
    {


        [HttpGet]
        public JsonResult GetDirectoryItems(int ID)
        {
            if (ID == -1)
            {
                var data = UOW.Repo_rootDirectory.All_NoTrack_List;

                var json = new ViewModelItems(true, "")
                {
                    ParentID = -1,
                    LogicPath = @"\",
                    ParentName = "Корень",
                    CurrentID = ID
                };

                data.ForEach((e) =>
                {
                    json.items.Add(new ViewModelItem()
                    {
                        ID = e.ID,
                        Name = e.Name,
                        Type = e.Type.ToString()
                    });
                });

                return Json(json, JsonRequestBehavior.AllowGet);
            }
            else
            {
                var data = UOW.context.FS_Items.
                    Where(e => e.ID == ID).
                    AsNoTracking().
                    Include("_Items").
                    First();

                var json = new ViewModelItems(true, "")
                {
                    ParentID = data.IsRoot ? -1 : data.Parent_ID.Value,
                    LogicPath = data.LogicPath,
                    ParentName = data.IsRoot ? "Корень" : data.Parent.Name
                };

                data.Items.ToList().ForEach((e) =>
                {
                    if (e.Type == Enum_BaseDirectoryEntity.UploadFile)
                        return;

                    json.items.Add(new ViewModelItem()
                    {
                        ID = e.ID,
                        Name = e.Name,
                        Type = e.Type.ToString(),
                        Size = (e is SFile) ? e.GetSize(Enum_FileSize.MByte).ToString() : ""
                    });
                });

                return Json(json, JsonRequestBehavior.AllowGet);
            }
        }


        [HttpGet]
        public FileResult GetFile(int ID)
        {
            var file = UOW.Repo_SFile.All_NoTrack.FirstOrDefault(e => e.ID == ID);

            return File(file.Info.Open(FileMode.Open, FileAccess.Read), "application/octet-stream", file.Name);
        }

        [HttpPost]
        public JsonResult DeleteFile(int ID)
        {
            try
            {
                var file = UOW.Repo_SFile.All.FirstOrDefault(e => e.ID == ID);
                UOW.Repo_SFile.Delete(file);
            }
            catch (Exception ex)
            {
                var json_err = new DeleteResult(false, ex.Message);

                return Json(json_err, JsonRequestBehavior.AllowGet);
            }

            var json = new DeleteResult(true, "");

            return Json(json, JsonRequestBehavior.AllowGet);
        }

        [HttpGet]
        public async Task<JsonResult> ScanDirectory(int ID)
        {
            if (ID == -1)
            {
                var dir = UOW.Repo_rootDirectory.All_List;
                new ConfigurationServices(UOW).
                    ReadConfiguration();
                await new ScanServices(UOW).ScanAllDirs();
            }
            else
            {
                var dir = UOW.context.FS_Items.
                    FirstOrDefault(e => e.ID == ID);
                await new ScanServices(UOW).
                    RecursScanDirectoryAsync((SDirectory)dir, false);


                var items = UOW.context.FS_Items.
                    FirstOrDefault(e => e.ID == ID).Items.ToList();
            }


            return Json(true, JsonRequestBehavior.AllowGet);
        }


        public JsonResult CreateDirectory(int ParentID, string Name)
        {
            var parent = UOW.context.FS_Items.
                FirstOrDefault(e => e.ID == ParentID);

            UOW.Repo_SDirectory.
                Create(new SDirectory((SDirectory)parent, Name));

            return Json(true, JsonRequestBehavior.AllowGet);
        }

    }
}