﻿
class ExplorerActionsControl extends React.Component {

    constructor(props) {
        super(props);
        console.log('ExplorerControl start');

        this.state = { ResultMsg: "" }
        this.fileExplorerServices = new FileExplorerServices();

        this.OnDownloadClick = this.OnDownloadClick.bind(this);
        this.OnDeleteClick = this.OnDeleteClick.bind(this);
        this.OnCreateDirectoryClick = this.OnCreateDirectoryClick.bind(this);
    }


    OnDownloadClick(sender) {

        let selected = this.props.ParentComponent.refs.
            FileExplorerControl.GetSelectedID();

        selected.map((e) => {
            console.log("OnDownload " + e);

            this.fileExplorerServices.OpenDownload(e);
        });
    }

    OnDeleteClick(sender) {

        let selected = this.props.ParentComponent.refs.
            FileExplorerControl.GetSelectedID();
        let promises = [];

        selected.map((e) => {
            console.log("OnDelete " + e);

            promises.push(
                this.fileExplorerServices.DeleteAsync(e)
            );
        });

        Promise.all(promises).
            then(function (res) {

                let promises = [];
                res.map((e) => {
                    promises.push(e.json());
                })

                let Result = "";

                Promise.all(promises).
                    then(function (data) {

                        data.map(function (e) {
                            Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";
                        });

                        this.setState({ ResultMsg: Result });
                        this.props.
                            ParentComponent.OnItemsChange();
                    }.bind(this));

            }.bind(this)
            )
    }


    OnMoveClick(sender) {
        //GetSelectedFiles

        //New sub windows for select path to move
    }

    OnCreateDirectoryClick(sender) {
        let dirname = this.refs.DirectoryName.value;
        let id = this.props.ParentComponent.GetID();

        let url = "/Explorer/CreateDirectory?ParentID=" + id
            + "&Name=" + dirname;

        this.fileExplorerServices.CreateDirectoryAsync(dirname, id).
            then(function (response) {
                response.json().then(function (data) {
                    this.props.ParentComponent.OnItemsChange();
                }.bind(this));
            }.bind(this));

        this.refs.DirectoryName.value = "";
    }

    render() {

        return (
            <div>
                <p>ExplorerControlPanel</p>

                <p>
                    <input ref="DirectoryName" />
                    <button onClick={this.OnCreateDirectoryClick}>CreateDirectory</button>
                </p>

                {
                    (
                        () => {
                            if (this.state.ResultMsg != "") {
                                return <p>{this.state.ResultMsg}</p>
                            }
                        }).bind(this)()
                }

                <table>
                    <tr>
                        <th><button onClick={this.OnDownloadClick}>Скачать</button></th>
                        <th><button onClick={this.OnDeleteClick}>Удалить</button></th>
                        <th><button>Переместить</button></th>
                    </tr>
                </table>
            </div>
        );

    }
}
