﻿
class FileExplorerServices {
    constructor() {

        this.URL_DirectoryItems = "/Explorer/GetDirectoryItems?ID=";
        this.URL_ScanDirectory = "/Explorer/ScanDirectory?ID=";

        this.URL_Delete = "/Explorer/DeleteFile?ID=";
        this.URL_Download = "/Explorer/GetFile?ID=";
        this.URL_CreateDirectory = "/Explorer/CreateDirectory?";


    }


    async DirectoryGetItemsAsync(ID) {
        let url = this.URL_DirectoryItems + ID;

        return fetch(
            url,
            {
                ID: ID
            })
    }

    async ScanDirectoryAsync(ID) {
        let url = this.URL_ScanDirectory + ID;

        return fetch(url);
    }


    async DeleteAsync(ID) {
        let url = this.URL_Delete + ID;

        return fetch(
            url,
            {
                method: 'POST'
            }
        )
    }

    OpenDownload(ID) {
        let url = this.URL_Download + ID;

        window.open(url, '_blank');
    }

    async CreateDirectoryAsync(dirname, id) {
        let url = this.URL_CreateDirectory+"ParentID = " + id
            + "&Name=" + dirname;

        return fetch(url);
    }

}