﻿
class FileExplorerRow extends React.Component {

    constructor(props) {
        super(props);
        console.log('FileExplorerRow start ' + this.props.ID);

        this.state = { ID: this.props.ID, Data: this.props.data };

        this.GetDate = this.GetDate.bind(this);
        this.GetRowID = this.GetRowID.bind(this);
        this.GetDataID = this.GetDataID.bind(this);
        this.IsCheked = this.IsCheked.bind(this);
        this.OnDirectoryClick = this.OnDirectoryClick.bind(this);
    }

    componentWillReceiveProps(nextProps) {
        this.props = nextProps;
        this.setState({ ID: this.props.ID, Data: this.props.data });
    }

    GetDate() {
        return this.state.Data;
    }

    GetRowID() {
        return this.state.ID;
    }
    GetDataID() {
        return this.state.Data.ID;
    }
    IsCheked() {
        if (this.refs.Select == undefined)
            return false;

        return this.refs.Select.checked;
    }


    OnDirectoryClick() {
        this.props.ParentComponent.OnDirectoryClick(this.GetDataID());
    }

    render() {
        let state = this.state;
        let elem = state.Data;

        return (
            <tr>
                <td>{elem.ID}</td>
                {
                    (() => {
                        if (elem.Type === "RootDirectory" || elem.Type === "Directory") {
                            return (
                                <td></td>
                            )
                        }
                        else {
                            return (
                                <td><input ref="Select" type="checkbox" /></td>
                            )
                        }
                    }).bind(this)()
                }

                <td>{elem.Name}</td>
                <td>{elem.Type}</td>
                <td>{elem.Size}</td>

                {
                    (() => {
                        if (elem.Type === "RootDirectory" || elem.Type === "Directory") {
                            return (
                                <td><Link to={`/?ID=${elem.ID}`}><button id={elem.ID} onClick={this.OnDirectoryClick}>
                                    Перейти</button></Link></td>
                            )
                        }
                        else {
                            return (
                                <td></td>
                            )
                        }
                    }).bind(this)()
                }
            </tr>
        );

    }
}