﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Model.Entities.Users;

namespace Web.Controllers
{

    public class AuthResult
    {
        public bool Successe { set; get; }
        public string ResMsg { set; get; }

        public string Token { set; get; }
        public string UserName { set; get; }
    }


    public class UserController : BaseController
    {

        /// <summary>
        /// Должен выдавать токен авторизации
        /// </summary>
        /// <param name="Login"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        /// 
        [HttpGet]
        public JsonResult Auth(string Login, string Password)
        {
            var user = UOW.Repo_User.All_NoTrack.
                FirstOrDefault(e => e.Login == Login && e.Password == Password
                && e.IsActive);

            if (user != null)
            {
                return Json(new AuthResult()
                {
                    Successe = true,

                    Token = user.ID.ToString(),
                    UserName = user.Login
                }, JsonRequestBehavior.AllowGet);
            }
            else
            {
                return Json(new AuthResult()
                {
                    Successe = false,
                    ResMsg = "Пользователь не найден или заблокирован",

                    Token = ""
                }, JsonRequestBehavior.AllowGet);
            }
        }



        public JsonResult CreateUser(string Login, string Password)
        {
            UOW.Repo_User.Create(new User()
            {
                Login = Login,
                Password = Password,
                IsActive = true,
                Groups = new List<Group>()
                {
                    UOW.Repo_Group.GetDefaultGroup(EnumDefaultGroups.Пользователи)
                }
            });

            return Json(true, JsonRequestBehavior.AllowGet);
        }


    }
}