﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Model.Entities.Base;
using Model.Entities.Files.FS_Entities;
using Model.UnitsOfWork;
using BLL.Services;

using Model.ViewModel.Files;

namespace Web.Controllers
{
    class UploadInfo
    {
        public bool State { set; get; }
        public string Msg { set; get; }

        public int ID { set; get; }
    }


    public class UploadFilesController : BaseController
    {
        
        //[HttpGet]
        //public ActionResult UploadPage()
        //{
        //    return View();
        //}

        [HttpPost]
        public JsonResult StartUpload(int ParentID, string Name, long size)
        {
            int ID;

            try
            {
                var parent = UOW.context.FS_Items.FirstOrDefault(e => e.ID == ParentID);
                var proj = uploadServices.StartUpload((SDirectory)parent, Name, size);

                ID = proj.ID;
            }
            catch (Exception ex)
            {
                return Json(new UploadInfo()
                {
                    State = false,
                    Msg = ex.FullMessage()
                });
            }

            return Json(new UploadInfo()
            {
                State = true,
                ID = ID
            });
        }

        [HttpPost]
        public JsonResult UploadBlob()
        {
            UploadBlob model = new UploadBlob();

            try
            {
                model.ID = int.Parse(Request.Form["ID"]);
                model.Data = Request.Unvalidated.Form["chunk"];

                var prog = UOW.Repo_SFileUpload.All.
                    FirstOrDefault(e => e.ID == model.ID);

                uploadServices.UploadChunk(prog, model.ToByte());
            }
            catch (Exception ex)
            {
                return Json(new UploadInfo()
                {
                    State = false,
                    Msg = ex.FullMessage()
                });
            }

            return Json(new UploadInfo()
            {
                State = true
            });
        }

        [HttpPost]
        public JsonResult Cansel(int ID)
        {
            var prog = UOW.Repo_SFileUpload.All.
                FirstOrDefault(e => e.ID == ID);

            uploadServices.Cansel(prog);

            return Json(true);
        }

    }
}