﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Configuration;

using BLL.Base;

using Model.UnitsOfWork;
using Model.Entities.Files.FS_Entities;
using Model.Entities.Files.Repo;

namespace BLL.Services
{
    public class ConfigurationServices : BaseServices
    {
        const string FolderPrefix = "WorkFolder";

        public ConfigurationServices(UOW uOW) : base(uOW) { }

       
        public void ReadConfiguration()
        {
            var config = ConfigurationManager.AppSettings;

            var folder_values = new LinkedList<string>(config.GetValues(FolderPrefix).First().Split(';'));
            var db_dir = UOW.Repo_rootDirectory.All;

            foreach (var elem in db_dir)
            {
                if (!folder_values.Contains(elem.PhysicalPath))
                    UOW.Repo_rootDirectory.DeleteInList(elem);
                else
                    folder_values.Remove(elem.PhysicalPath);
            }

            if (folder_values.Count != 0)
            {
                var nRoot = new List<SRootDirectory>(folder_values.Count);

                foreach (var elem in folder_values)
                    nRoot.Add(UOW.Repo_rootDirectory.
                        Create(new SRootDirectory(elem, Path.GetFileName(elem))));
            }
        }       
    }
}
