﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Model.Entities.Files;
using Model.UnitsOfWork;

namespace Model.Entities.Base
{
    public abstract class Base_FS_Repository<T> : BaseRepository<T> where T : FS_Item
    {
        public DbSet<FS_Item> Set_Fs => context.Set<FS_Item>();


        public Base_FS_Repository(Context context) : base(context) { }

        /// <summary>
        /// Рекурсия
        /// Функция удаляет данные о файлах из базы, при этом не влияя на ФС
        /// Обычно вызывается при сканировании ФС, когда папка/файл из базы не найдена в ФС
        /// </summary>
        /// <param name="elem"></param>
        public void DeleteInList(FS_Item elem)
        {
            foreach (var item in elem.Items)
            {
                _DeleteInList(item);
            }

            Set_Fs.Remove(elem);
            context.SaveChanges();
        }

        private void _DeleteInList(FS_Item elem)
        {
            foreach (var item in elem.Items)
            {
                DeleteInList(item);
            }
            Set_Fs.Remove(elem);
        }

    }
}
