﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Model.Entities.Base;
using Model.Entities.Files;
using Model.Entities.Files.FS_Entities;
using Model.Entities.Files.Repo;
using Model.Entities.Users;

namespace Model.UnitsOfWork
{
    public class UOW
    {
        public readonly Context context = new Context();

        public readonly Repo_SRootDirectory Repo_rootDirectory;
        public readonly Repo_SDirectory Repo_SDirectory;
        public readonly Repo_SFile Repo_SFile;
        public readonly Repo_SFileUpload Repo_SFileUpload;


        public readonly Repo_User Repo_User;
        public readonly Repo_Group Repo_Group;

        //public Base_FS_Repository<FS_Item> Repo_FS<T>() where T: FS_Item
        //{
        //    if (typeof(T).Name == "SFile")
        //    {
        //            return Repo_SFile;
        //    }

        //    throw new Exception();
        //}

        public UOW()
        {
            Repo_rootDirectory = new Repo_SRootDirectory(context);
            Repo_SDirectory = new Repo_SDirectory(context);
            Repo_SFile = new Repo_SFile(context);
            Repo_SFileUpload = new Repo_SFileUpload(context);

            Repo_Group = new Repo_Group(context);
            Repo_User = new Repo_User(context);


            if (Repo_User.All_NoTrack.Count() == 0)
            {
                Repo_User.Create(new User()
                {
                    Login = "Admin",
                    Password = "Admin",
                    IsActive = true,
                    Groups = new List<Group>()
                    {
                        Repo_Group.GetDefaultGroup(EnumDefaultGroups.Администраторы)
                    }
                });              
            }
        }
    }
}
