﻿
class UserControl extends React.Component {

    constructor(props) {
        super(props);
        console.log('UserControl start');

        this.state = { UserName: "", AuthResult: "" };
        this.userServices = new UserServices();

        this.AuthClick = this.AuthClick.bind(this);
        this.LogoutClick = this.LogoutClick.bind(this);
    }

    //Кнопка входа
    AuthClick() {
        let login = this.refs.Login.value;
        let password = this.refs.Password.value;

        this.userServices.Auth(login, password)
            .then(function (response) {
                response.json().then(function (data) {

                    if (data.Successe) {
                        this.userServices.SetTocken(data.Token);
                        this.setState({ UserName: data.UserName, AuthResult: "" });
                    }
                    else {
                        this.userServices.SetTocken("");
                        this.setState({ UserName: "", AuthResult: data.ResMsg });
                    }

                }.bind(this));
            }.bind(this));
    }

    //Кнопка выхода
    LogoutClick() {
        this.userServices.SetTocken("");
        this.setState({ UserName: "", AuthResult: "" });
    }


    render() {
        let state = this.state;


        if (this.userServices.IsAuth()) {
            return (
                <div>
                    <p>Вы авторизованы. Пользователь: {state.UserName}.</p>
                    <button onClick={this.LogoutClick}>Logout</button>
                </div>
            );
        }
        else {
            return (
                <div>
                    <p>Вы не авторизованы {state.UserName}.  Вход:</p>

                    {(() => {

                        if (state.AuthResult != "") {
                            return <p>{state.AuthResult}</p>;
                        }
                    }).bind(this)()
                    }

                    <input ref="Login" />
                    <br />
                    <input ref="Password" />
                    <br />
                    <button onClick={this.AuthClick}>Auth</button>
                </div>
            );
        }
    }
}