﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using BLL.Base;

using Model.UnitsOfWork;
using Model.Entities.Files.FS_Entities;
using Model.Entities.Files.Repo;
using Model.Tools;

namespace BLL.Services
{
    /// <summary>
    /// Сервис, иницилизирующий корень фс в базе на основе файла конфигурации
    /// </summary>
    public class ConfigurationServices : BaseServices
    {
        readonly ConfigTools ConfigTools;

        public ConfigurationServices(UOW uOW, ConfigTools ConfigTools) : base(uOW)
        {
            this.ConfigTools = ConfigTools;
        }

       
        public void ReadConfiguration()
        {
            var folder_values = new LinkedList<string>(ConfigTools.Data.RootDirs);
            var db_dir = UOW.Repo_SRootDirectory.All;

            foreach (var elem in db_dir)
            {
                if (!folder_values.Contains(elem.PhysicalPath))
                    UOW.Repo_SRootDirectory.DeleteInList(elem);
                else
                    folder_values.Remove(elem.PhysicalPath);
            }

            if (folder_values.Count != 0)
            {
                var nRoot = new List<SRootDirectory>(folder_values.Count);

                foreach (var elem in folder_values)
                {
                    nRoot.Add(UOW.Repo_SRootDirectory.
                        Create(new SRootDirectory(elem, Path.GetFileName(elem))));
                }
            }
        }       
    }
}
