﻿
import React from 'react';
import { Form } from 'react-bootstrap' 
import { ButtonToolbar, Button } from 'react-bootstrap';


import Notification from '../../../Tools/Notification'

import AuthServices from '../../../Services/AuthServices'

import BaseControl from '../../BaseControl.jsx'

export default class UserDetailControl extends BaseControl {

    constructor(props) {
        super(props, "UserDetailControl");

        this.authServices = new AuthServices();
    }


    SaveChange() {       
        let password = this.refs.Password.value;
        this.refs.Password.value = "";

        let repeat_password = this.refs.RepeatPassword.value;
        this.refs.RepeatPassword.value = "";
        

        if (password !== repeat_password) {
            Notification.MesEr("password != repeat_password","SaveChange");
            return;
        }

        this.authServices.SetUserInfo(password).
            then(function (data) {
                if (data.Successe) {
                    Notification.MesOk(data.ResMessage, "SaveChange");
                }
                else {
                    Notification.MesEr(data.ResMessage, "SaveChange");
                }

            });        
    }

    render() {

        return (
            <div>
                <Form.Control ref="Password" type="password" placeholder="New password" />
                <Form.Control ref="RepeatPassword" type="password" placeholder="Repeat Password" />
                <button onClick={this.SaveChange}>SaveChange</button>
            </div>
        );

    }
}
