﻿
import React from 'react';
import { Row, Col } from 'react-bootstrap' 

import Configuration from '../../Tools/Configuration'

import BaseControl from '../BaseControl.jsx'
import FileExplorerControl from '../Controls/FileExplorer/FileExplorerControl.jsx'
import ExplorerActionsControl from '../Controls/FileExplorer/ExplorerActionsControl.jsx'
import UploaderControl from '../Controls/FileExplorer/UploaderControl.jsx'
import BootstrapControl from '../Controls/BootstrapControl.jsx'

export default class FileExplorerPage extends BaseControl {

    constructor(props) {
        super(props, "FileExplorerPage");

        let a = Configuration.EnviromentValue;
        debugger;

        let DirectoryID = -1;
        //Получить ID из url
        let url_ID = new URL(window.location.href).
            searchParams.get("ID");

        if (url_ID != null)
            DirectoryID = url_ID;

        this.GlobalState.MainExplorer = {
            //ID папки
            ID: DirectoryID,
            //Может ли текущий пользователь менять содержимое папки
            CanChangeDirectoryItems: false,
            //Отображать или нет SelectColumn
            ShoSelectColumn: true,
            //Названия события изменения содержимого папки
            ChangeEvent: "OnItemsChange_Main"
        };
        //this.EventRegister.EventAction("OnItemsChange");
    }


    render() {
        return (
            <div>
                <FileExplorerControl ref="FileExplorerControl"
                    ParentComponent={this}
                    //Параметры для того, чтобы можно было содержать 
                    //несколько элементов данного типа с разными дирректориями                   
                    CurrentDirectoryName={"MainExplorer"}            
                />
                <hr />
                {
                    //(this.GlobalState.MainExplorer.ID != Configuration.RooDirectoryID)
                    //?
                    //<div>
                    //    <Row style={{ marginLeft: '1rem' }}>
                    //        <Col>
                    //            <ExplorerActionsControl ref="ExplorerActionsControl"
                    //                ParentComponent={this}
                    //                CanWrite={true}
                    //            />
                    //        </Col>
                    //        <Col>
                    //            <UploaderControl ref="UploaderControl"
                    //                ParentComponent={this}
                    //            />
                    //        </Col>
                    //    </Row>
                    //</div>
                    //: null
                }
                <div>
                    <Row style={{ marginLeft: '1rem' }}>
                        <Col>
                            <ExplorerActionsControl ref="ExplorerActionsControl"
                                ParentComponent={this}
                                CanWrite={true}
                            />
                        </Col>
                        <Col>
                            <UploaderControl ref="UploaderControl"
                                ParentComponent={this}
                            />
                        </Col>
                    </Row>
                </div>
                {
                    (Configuration.EnviromentValue == 'Development')
                        ?
                        <div>
                            <hr />
                            <BootstrapControl />
                            <hr />
                        </div>
                        : null
                }
                

            </div>
        );
    }
}

