
// path       
const path = require('path');


module.exports = {

    // .      
    devtool: 'source-map',

    //  (index.js)
    entry: {
        app: "./src/JS/index.js"
    },    

    //
    output: {
        // 
        //[name] -    (app__bundle.js)
        filename: "[name]_bundle.js",
        // 
        path: path.resolve(__dirname, "./SPA_Build"),
        //  dev 
        publicPath: "/SPA_Build"
    },

    //     
    module: {
        // 
        rules: [
            // js
            {
                // . .  
                test: /\.js$/,
                //  ( )
                loader: 'babel-loader',
                //      node_modules (..   )
                exclude: ['/node_modules/', '/Enviroment']
            },
            //
            {
                // . .  
                test: /\.js$/,
                //  ( )
                loader: 'babel-loader',
                //      node_modules (..   )
                exclude: ['/node_modules/', '/src']
            },
            // jsx
            {
                //   
                test: /\.jsx?$/, 
                exclude: /(node_modules)/,
                //  
                loader: "babel-loader"
            },
            // CSS
            {
                test: /\.css$/,
                use: ['style-loader', 'css-loader']
            },
            // 
            {
                test: /\.(png|jpe?g|gif)$/i,
                loader: 'file-loader',
                options: {
                    //    
                    name: '[path][name].[ext]',
                    //        [path]
                    //       build/src/...
                    context: 'src',
                    // public   
                    publicPath: 'SPA_Build'
                }
            }
        ]
    },

    // dev 
    devServer: {
        
        port: 8091,
        //   
        overlay: true,
        // 
        //openPage: 'SPA_Build/index.html',
        //SPA route.  index     
        historyApiFallback: {
            index: 'index.html'
        },

        proxy: {            

            // WevAPI
            '/api/*': {
                target: 'http://localhost:47780'
            }
        }
    }

}