﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Data.Entity;

using BLL.Base;
using BLL.Services.System;
using Model.Entities.Users;
using Model.Entities.Files.FS_Entities;
using Model.UnitsOfWork;
using Model.ViewModel;
using Model.ViewModel.Edit;

namespace BLL.Services.Mapper
{
    public class RootDirsMapper : BaseServices
    {
        readonly PermissionServices permissionServices;
        readonly Func<string> AppDataPath;

        public RootDirsMapper(UOW UOW, PermissionServices permissionServices, Func<string> AppDataPath) : base(UOW)
        {
            this.permissionServices = permissionServices;
            this.AppDataPath = AppDataPath;
        }


        /// <summary>
        /// DB -> Info
        /// Модель информации о RootDirs
        /// </summary>
        /// <returns></returns>
        public List<InfoRootDirModel> GetInfo_RootDir()
        {
            var dirs = UOW.Repo_SRootDirectory.All_List;

            return new List<InfoRootDirModel>(dirs.Select(e => new InfoRootDirModel()
            {
                ID = e.ID,
                Name = e.Name,
                CanDownload = false,
                CanOpen = false,
                CanUpload = false
            }));
        }


        /// <summary>
        /// DB -> Edit
        /// Модель для редактирования RootDir
        /// </summary>
        /// <returns></returns>
        public List<EditRootDirModel> GetEdit_Group()
        {
            var dirs = UOW.Repo_SRootDirectory.All_List;                

            return dirs.Select(e => new EditRootDirModel()
            {
                ID = e.ID,
                Name = e.Name,
                Changes = EnumChanges.NoChange
            }).ToList();
        }

        /// <summary>
        /// Edit -> DB
        /// Преобразование Edit в db Entitites
        /// </summary>
        /// <param name="editGroup"></param>
        /// <returns></returns>
        public List<(EditRootDirModel Edited, SRootDirectory DB)> GetEntities_RootDir(List<EditRootDirModel> edit)
        {
            List<(EditRootDirModel Edited, SRootDirectory DB)> res = 
                new List<(EditRootDirModel Edited, SRootDirectory DB)>(edit.Count());
            var dirs = UOW.Repo_SRootDirectory.All_List;

            foreach (var elem in edit)
            {
                SRootDirectory current_dir = null;

                switch (elem.Changes)
                {
                    case EnumChanges.Create:
                        current_dir = new SRootDirectory(AppDataPath() + "\\" + elem.Name, elem.Name);                       

                        break;
                    case EnumChanges.Update:
                        current_dir = UOW.Repo_SRootDirectory.All.
                            FirstOrDefault(e => e.ID == elem.ID);
                        //current_dir.Name = elem.Name;
                        break;
                    case EnumChanges.Delete:
                        current_dir = UOW.Repo_SRootDirectory.All.
                            FirstOrDefault(e => e.ID == elem.ID);
                        break;
                }

                res.Add(new ValueTuple<EditRootDirModel, SRootDirectory>(elem, current_dir));
            }

            return res;
        }

    }
}
