﻿
import React from 'react';
import ReactDOM from 'react-dom';
import { BrowserRouter as Router } from 'react-router-dom';

import Configuration from '../../Tools/Configuration'

import BaseControl from '../BaseControl.jsx'
import Header from '../Controls/Layout/Header.jsx'
import Footer from '../Controls/Layout/Footer.jsx'
import RouteSystem from '../RouteSystem.jsx'

import EnviromentServices from '../../Services/EnviromentServices.js'

class LayoutPage extends BaseControl {

    constructor(props) {
        super(props, "LayoutPage");
    }



    render() {
        return (
            <Router>
                <div>
                    <Header/>

                    <RouteSystem/>

                    <Footer/>
                </div >
            </Router>
        );
    }
}


new EnviromentServices()
    .GetEnv()
    .then(
        function (data) {

            Configuration.EnviromentValue
                = data.Enviromet;

            console.log("Enviroment: " + Configuration.EnviromentValue);

            ReactDOM.render(
                <LayoutPage />,
                document.getElementById("App")
            )
        },
        function (error) {
            //Добавить небольшой контрол с ошибкой подключения к API
            console.error("Не удалось получить информацию об окружении с API");

            console.log("Enviroment: " + Configuration.EnviromentValue);
        }
);









