﻿
import React from 'react';
import { Link } from 'react-router-dom';
import { Nav, Navbar, NavDropdown, MenuItem, NavItem } from 'react-bootstrap'

import AuthServices from '../../Services/AuthServices'
import UserControl from '../Controls/User/UserControl.jsx'

import BaseControl from '../BaseControl.jsx'


export default class MenuControl extends BaseControl {

    constructor(props) {
        super(props, "MenuControl");

        this.authServices = new AuthServices();
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User != undefined
                ? this.GlobalState.User.IsAdmin
                : false
        };

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.setState({
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User.IsAdmin
        });
    }

    render() {

        return (
            <Navbar bg="dark" variant="dark">
                {/* "Link" in brand component since just redirect is needed */}
                <Navbar.Brand><img
                    alt=""
                    src="https://resize.yandex.net/imgs_touch?key=0bad711426e8ab708e400c111664d891&url=https%3A%2F%2Fi.ya-webdesign.com%2Fimages%2Ffolder-png-icons-3.png&width=1888&height=1562&typemap=png%3Apng%3B*%3Ajpg&quality=60&use-cache-headers=yes&crop=no&enlarge=no"
                    width="30"
                    height="30"
                    className="d-inline-block align-top"
                />
                    {' WebFileServer'}</Navbar.Brand>
                <Nav>
                    {/* "NavLink" here since "active" class styling is needed */}
                    <Nav.Link as={Link} to='/'>Файлы</Nav.Link>

                    <NavDropdown title={this.state.IsAuth ? "Личный кабинет" : "Авторизация"}>
                        <UserControl ref="UserControl" />
                    </NavDropdown>

                    {this.state.IsAuth && this.state.IsAdmin
                        ?                        
                        <Nav.Link as={Link} to='/Admin'>Администрирование</Nav.Link>
                        : null
                    }
  
                    }
                </Nav>
            </Navbar>
        );
    }
}

